/// <reference path="../../headers/common.d.ts" />
System.register(["app/plugins/sdk", "moment", "jquery"], function (exports_1, context_1) {
    "use strict";
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var sdk_1, moment_1, jquery_1, PanelCtrl;
    var __moduleName = context_1 && context_1.id;
    return {
        setters: [
            function (sdk_1_1) {
                sdk_1 = sdk_1_1;
            },
            function (moment_1_1) {
                moment_1 = moment_1_1;
            },
            function (jquery_1_1) {
                jquery_1 = jquery_1_1;
            }
        ],
        execute: function () {/// <reference path="../../headers/common.d.ts" />
            PanelCtrl = /** @class */ (function (_super) {
                __extends(PanelCtrl, _super);
                function PanelCtrl($scope, $injector, $http) {
                    var _this = _super.call(this, $scope, $injector) || this;
                    _this.$scope = $scope;
                    _this.$injector = $injector;
                    _this.$http = $http;
                    // Re-init all scope params
                    _this.reset($scope);
                    $scope.logLocation = '';
                    $scope.version = '';
                    $scope.errorMessage = '';
                    $scope.lastCheckDate = localStorage.getItem('lastCheck') ? moment_1.default(Number(localStorage.getItem('lastCheck'))).locale('en').format('MMMM DD, H:mm') : '';
                    $scope.currentVersion = localStorage.getItem('currentVersion') || '';
                    $scope.currentReleaseDate = localStorage.getItem('currentReleaseDate') || '';
                    $scope.nextVersion = localStorage.getItem('nextVersion') || '';
                    $scope.newReleaseDate = localStorage.getItem('newReleaseDate') || '';
                    $scope.checkForUpdate = _this.checkForUpdate.bind(_this, $scope, $http);
                    $scope.getLog = _this.getLog.bind(_this, $scope, $http);
                    $scope.showReleaseNotes = _this.showReleaseNotes.bind(_this, $scope);
                    $scope.getCurrentVersion = _this.getCurrentVersion.bind(_this, $scope, $http);
                    $scope.getCurrentVersion($scope, $http);
                    var timeDiff = Date.now() - Number(localStorage.getItem('lastCheck'));
                    if (timeDiff >= 1000 * 60 * 60) {
                        _this.checkForUpdate($scope, $http);
                    }
                    return _this;
                }
                /**
                 * Show error message if update is fail
                 * @param message - kind of error message
                 */
                PanelCtrl.prototype.displayError = function ($scope, message) {
                    $scope.isChecked = true;
                    $scope.errorMessage = message;
                    setTimeout(function () {
                        $scope.isChecked = false;
                        $scope.errorMessage = '';
                        $scope.$apply();
                    }, 5000);
                };
                /**
                 * Send request to check if update possible and re-init params
                 */
                PanelCtrl.prototype.checkForUpdate = function ($scope, $http) {
                    var _this = this;
                    var refreshButton = jquery_1.default('#refresh');
                    refreshButton.addClass('fa-spin');
                    $http({
                        method: 'GET',
                        url: PanelCtrl.API.CHECK_FOR_UPDATE,
                    }).then(function (res) {
                        $scope.isChecked = true;
                        $scope.nextVersion = res.data.version || '';
                        $scope.newReleaseDate = res.data.release_date ? (new Date(res.data.release_date)).toLocaleString('en-US', PanelCtrl.RELEASE_DATE_OPTION) : '';
                        _this.getCurrentTime($scope);
                        _this.setNextVersionData($scope);
                    }).catch(function () {
                        _this.displayError($scope, PanelCtrl.ERRORS.NOTHING_TO_UPDATE);
                        _this.getCurrentTime($scope);
                        _this.setNextVersionData();
                    });
                    refreshButton.removeClass('fa-spin');
                };
                /**
                 * Save current time to local storage
                 * @param $scope
                 */
                PanelCtrl.prototype.getCurrentTime = function ($scope) {
                    localStorage.setItem('lastCheck', Date.now().toString());
                    $scope.lastCheckDate = moment_1.default(Number(localStorage.getItem('lastCheck'))).locale('en').format('MMMM DD, H:mm');
                };
                /**
                 * Send request to get current version
                 */
                PanelCtrl.prototype.getCurrentVersion = function ($scope, $http) {
                    $http({
                        method: 'GET',
                        url: PanelCtrl.API.GET_CURRENT_VERSION,
                    }).then(function (res) {
                        $scope.version = res.data.version;
                        $scope.currentReleaseDate = res.data.release_date ? (new Date(res.data.release_date)).toLocaleString('en-US', PanelCtrl.RELEASE_DATE_OPTION) : '';
                        localStorage.setItem('currentVersion', $scope.version);
                        localStorage.setItem('currentReleaseDate', $scope.currentReleaseDate);
                        $scope.currentVersion = localStorage.getItem('currentVersion');
                        $scope.currentReleaseDate = localStorage.getItem('currentReleaseDate');
                        jquery_1.default('#refresh').removeClass('fa-spin');
                    }).catch(function () {
                        jquery_1.default('#refresh').removeClass('fa-spin');
                        //TODO: add error handler
                    });
                };
                /**
                 * Send request for get info about update status
                 */
                PanelCtrl.prototype.getLog = function ($scope, $http) {
                    var _this = this;
                    if (!$scope.logLocation.length)
                        return;
                    $http({
                        method: 'GET',
                        url: $scope.logLocation,
                    }).then(function (response) {
                        $scope.output = response.data.detail;
                        if (response.data.title === PanelCtrl.PROCESS_STATUSES.IN_PROGRESS)
                            window.setTimeout(_this.getLog.bind(_this, $scope, $http), 1000);
                        if (response.data.title === PanelCtrl.PROCESS_STATUSES.DONE) {
                            _this.reset($scope);
                            $scope.version = $scope.errorMessage ? $scope.version : $scope.nextVersion;
                            $scope.currentReleaseDate = $scope.errorMessage ? $scope.currentReleaseDate : $scope.nextReleaseDate;
                            localStorage.setItem('currentVersion', $scope.version);
                            $scope.currentVersion = localStorage.getItem('currentVersion');
                            _this.setNextVersionData();
                        }
                        if (response.data.title === PanelCtrl.PROCESS_STATUSES.FAILED) {
                            $scope.isChecked = true;
                            $scope.errorMessage = PanelCtrl.ERRORS.UPDATE;
                        }
                    }).catch(function () {
                        _this.reset($scope);
                        _this.setNextVersionData();
                    });
                };
                /**
                 * Send request to get info about new version
                 */
                PanelCtrl.prototype.showReleaseNotes = function ($scope) {
                    // TODO: will be implemented after API release
                };
                PanelCtrl.prototype.setNextVersionData = function ($scope) {
                    if ($scope === void 0) { $scope = false; }
                    localStorage.setItem('nextVersion', !$scope ? '' : $scope.nextVersion);
                    localStorage.setItem('newReleaseDate', !$scope ? '' : $scope.newReleaseDate);
                };
                /**
                 * Re-init all inner parameters that can be changed during update
                 */
                PanelCtrl.prototype.reset = function ($scope) {
                    $scope.output = '';
                    $scope.isChecked = false;
                    $scope.isOutputShown = true;
                };
                /**
                 * Urls to define panels templates
                 */
                PanelCtrl.TEMPLATES = {
                    MAIN: 'pmm-update-panel/index.html',
                };
                /**
                 * Urls to define API endpoints
                 */
                PanelCtrl.API = {
                    GET_CURRENT_VERSION: '/configurator/v1/version',
                    CHECK_FOR_UPDATE: '/configurator/v1/check-update',
                };
                /**
                 * Possible statuses of update version process (returned by backend)
                 */
                PanelCtrl.PROCESS_STATUSES = {
                    FAILED: 'failed',
                    IN_PROGRESS: 'running',
                    DONE: 'succeeded',
                    ERROR: 'error'
                };
                /**
                 * Possible errors during update process
                 */
                PanelCtrl.ERRORS = {
                    UPDATE: 'Error during update',
                    NOTHING_TO_UPDATE: 'Nothing to update',
                    INCORRECT_SERVER_RESPONSE: 'Incorrect server response'
                };
                /**
                 * Date format otpions
                 */
                PanelCtrl.RELEASE_DATE_OPTION = {
                    year: 'numeric',
                    month: 'long',
                    day: 'numeric'
                };
                /**
                 * Grafana param, define url of template that will be used for panel
                 */
                PanelCtrl.templateUrl = PanelCtrl.TEMPLATES.MAIN;
                return PanelCtrl;
            }(sdk_1.MetricsPanelCtrl));
            exports_1("PanelCtrl", PanelCtrl);
        }
    };
});
//# sourceMappingURL=module.js.map