/// <reference path="../../headers/common.d.ts" />
System.register(["app/plugins/sdk", "app/core/config", "jquery", "app/core/app_events"], function (exports_1, context_1) {
    "use strict";
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var sdk_1, config_1, jquery_1, app_events_1, PanelCtrl;
    var __moduleName = context_1 && context_1.id;
    return {
        setters: [
            function (sdk_1_1) {
                sdk_1 = sdk_1_1;
            },
            function (config_1_1) {
                config_1 = config_1_1;
            },
            function (jquery_1_1) {
                jquery_1 = jquery_1_1;
            },
            function (app_events_1_1) {
                app_events_1 = app_events_1_1;
            }
        ],
        execute: function () {/// <reference path="../../headers/common.d.ts" />
            PanelCtrl = /** @class */ (function (_super) {
                __extends(PanelCtrl, _super);
                function PanelCtrl($scope, $injector, templateSrv, $sce) {
                    var _this = _super.call(this, $scope, $injector) || this;
                    $scope.qanParams = {
                        'var-host': null,
                        'from': null,
                        'search': '',
                        'queryID': null,
                        'type': null,
                        'to': null,
                        'tz': config_1.default.bootData.user.timezone,
                        'theme': config_1.default.bootData.user.lightTheme ? 'light' : 'dark'
                    };
                    $scope.trustSrc = function (src) { return $sce.trustAsResourceUrl(src); };
                    _this.setUrl($scope, templateSrv);
                    $scope.$root.onAppEvent('template-variable-value-updated', _this.setUrl.bind(_this, $scope, templateSrv));
                    $scope.$watch('ctrl.range', function (newValue) {
                        if (!newValue)
                            return;
                        $scope.qanParams.from = newValue.from.valueOf();
                        $scope.qanParams.to = newValue.to.valueOf();
                    }, true);
                    return _this;
                }
                PanelCtrl.prototype.link = function ($scope, elem, $location, $window) {
                    var _this = this;
                    var _a;
                    var frame = elem.find('iframe');
                    var panel = elem.find('div.panel-container');
                    var panelContent = elem.find('div.panel-content');
                    // TODO: investigate this workaround. Inside $window - CtrlPanel
                    var location = $window.$injector.get('$location');
                    var window = $window.$injector.get('$window');
                    window.document.addEventListener('showSuccessNotification', function () { app_events_1.default.emit('alert-success', ['Content has been copied to clipboard']); }, false);
                    panel.css({
                        'background-color': 'transparent',
                        'border': 'none'
                    });
                    this.disableGrafanaPerfectScroll(elem);
                    this.fixMenuVisibility(elem);
                    $scope.ctrl.calculatePanelHeight = function () {
                        var h = frame.contents().find('body').height() || 400;
                        var documentH = (elem && elem[0]) ? elem[0].ownerDocument.height : h;
                        $scope.ctrl.containerHeight = documentH;
                        $scope.ctrl.height = documentH - 100;
                        frame.height(h + 100 + "px");
                        panel.height(h + 150 + "px");
                        panelContent.height("inherit");
                        panelContent[0].style.padding = '0 0 10px';
                    };
                    // init url
                    // updated url
                    $scope.$watch('qanParams', this.resetUrl.bind(this, $scope), true);
                    _a = this.retrieveDashboardURLParams(location.absUrl()), $scope.qanParams.queryID = _a[0], $scope.qanParams.type = _a[1], $scope.qanParams.search = _a[2];
                    frame.on('load', function () {
                        frame.contents().bind('click', function (event) {
                            var _a = _this.retrieveIFrameURLParams(event.currentTarget.URL), queryID = _a[0], type = _a[1], search = _a[2];
                            if (jquery_1.default(event.target).is('.fa-search') && (jquery_1.default('iframe').contents().find('#search-input')[0].value.length || jquery_1.default('iframe').contents().find('#search-input')[0].value === '')) {
                                search = jquery_1.default('iframe').contents().find('#search-input')[0].value;
                                queryID = 'null';
                                $scope.ctrl.calculatePanelHeight();
                                return _this.reloadQuery(window, queryID, type, search);
                            }
                            setTimeout(function () { return $scope.ctrl.calculatePanelHeight(); }, 10);
                            return queryID === 'null' || queryID === null || _this.reloadQuery(window, queryID, type, search);
                        });
                        frame.contents().bind('keyup', function (event) {
                            if ((jquery_1.default(event.target).is('#search-input') && event.keyCode === 13)) {
                                var _a = _this.retrieveIFrameURLParams(event.currentTarget.URL), queryID = _a[0], type = _a[1], search = _a[2];
                                $scope.ctrl.calculatePanelHeight();
                                return _this.reloadQuery(window, queryID, type, search);
                            }
                        });
                        frame.contents().bind('DOMSubtreeModified', function () { return setTimeout(function () { return $scope.ctrl.calculatePanelHeight(); }, 10); });
                    });
                };
                /**
                 * Workaround for scrolling through iframe
                 * Grafana perfect scroll is broken for iframe and should be disabled for this case
                 * @param elem - qan app panel HTML element
                 * @returns {void, boolean}
                 */
                PanelCtrl.prototype.disableGrafanaPerfectScroll = function (elem) {
                    if (!elem || !elem[0])
                        return false;
                    var perfectScrollContainers = elem[0].ownerDocument.getElementsByClassName('ps');
                    var rightScrollbarContainers = elem[0].ownerDocument.getElementsByClassName('ps__thumb-y');
                    [].forEach.call(perfectScrollContainers, function (container) { return container.setAttribute('style', 'overflow: auto !important'); });
                    [].forEach.call(rightScrollbarContainers, function (container) { return container.setAttribute('style', 'display: none !important'); });
                };
                PanelCtrl.prototype.fixMenuVisibility = function (elem) {
                    if (!elem || !elem[0])
                        return false;
                    var menu = elem[0].ownerDocument.getElementsByClassName('dropdown-menu');
                    [].forEach.call(menu, function (e) { return e.setAttribute('style', 'z-index: 1001'); });
                };
                PanelCtrl.prototype.reloadQuery = function (window, queryID, type, search) {
                    var _this = this;
                    if (queryID === void 0) { queryID = null; }
                    if (type === void 0) { type = null; }
                    if (search === void 0) { search = ''; }
                    var isQueryId = queryID && queryID !== 'null';
                    var isOnlyIDInUrl = isQueryId && !(jquery_1.default('iframe').contents().find('#search-input')[0].value.length);
                    var isOnlySearchInUrl = search && !isQueryId && !isOnlyIDInUrl;
                    var isBothInUrl = isQueryId && search && (jquery_1.default('iframe').contents().find('#search-input')[0].value.length);
                    var isBothNull = (queryID === null || queryID === 'null') && (search === null || search === '');
                    var conditions = [
                        {
                            getStr: function () { return '&queryID'; },
                            params: { queryID: queryID, type: type },
                            getCondition: function () { return isOnlyIDInUrl; },
                        },
                        {
                            getStr: function () { return (window.location.href.match(/&queryID/g) || []).length ? '&queryID' : '&search'; },
                            params: { search: search },
                            getCondition: function () { return isOnlySearchInUrl; },
                        },
                        {
                            getStr: function () { return '&queryID'; },
                            params: { queryID: queryID, type: type, search: search },
                            getCondition: function () { return isBothInUrl; },
                        },
                        {
                            getStr: function () { return '&search'; },
                            params: { queryID: queryID, type: type, search: search },
                            getCondition: function () { return isBothInUrl && ((window.location.href.match(/&search/g) || []).length > 1); },
                        },
                    ];
                    conditions.map(function (item) {
                        if (!item.getCondition())
                            return;
                        history.pushState({}, null, window.location.href.split(item.getStr())[0] + "&" + _this.encodeData(item.params));
                    });
                    if (isBothNull) {
                        history.pushState({}, null, "" + window.location.href.split('&search')[0]);
                        history.pushState({}, null, "" + window.location.href.split('&queryID')[0]);
                    }
                };
                PanelCtrl.prototype.retrieveDashboardURLParams = function (url) {
                    var currentURL = new URL(url);
                    return [currentURL.searchParams.get('queryID'), currentURL.searchParams.get('type'), currentURL.searchParams.get('search')];
                };
                PanelCtrl.prototype.retrieveIFrameURLParams = function (url) {
                    var currentURL = new URL(url);
                    var id = currentURL.searchParams.get('queryID');
                    var search = currentURL.searchParams.get('search');
                    var urlArr = url.split('/');
                    var type = urlArr[urlArr.length - 1].split('?')[0];
                    return [id, type, search];
                };
                PanelCtrl.prototype.encodeData = function (data) {
                    return Object.keys(data)
                        .map(function (key) { return data.hasOwnProperty(key) ? encodeURIComponent(key) + "=" + encodeURIComponent(data[key]) : null; })
                        .join('&');
                };
                // translates Grafana's variables into iframe's URL;
                PanelCtrl.prototype.setUrl = function ($scope, templateSrv) {
                    $scope.qanParams['var-host'] = templateSrv.variables[0].current.value;
                };
                PanelCtrl.prototype.resetUrl = function ($scope) {
                    var data = this.encodeData($scope.qanParams);
                    if ($scope.qanParams.type && $scope.qanParams.queryID)
                        $scope.url = "/qan/profile/report/" + $scope.qanParams.type + "?" + data;
                    else
                        $scope.url = "/qan/profile/?" + data;
                };
                PanelCtrl.template = "<iframe ng-src=\"{{trustSrc(url)}}\" style=\"width: 100%; height: 400px; border: 0;\" scrolling=\"no\" />";
                return PanelCtrl;
            }(sdk_1.MetricsPanelCtrl));
            exports_1("PanelCtrl", PanelCtrl);
        }
    };
});
//# sourceMappingURL=module.js.map