/// <reference path="../../headers/common.d.ts" />
System.register(["app/plugins/sdk", "app/core/config"], function (exports_1, context_1) {
    "use strict";
    var __extends = (this && this.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    var sdk_1, config_1, PanelCtrl;
    var __moduleName = context_1 && context_1.id;
    return {
        setters: [
            function (sdk_1_1) {
                sdk_1 = sdk_1_1;
            },
            function (config_1_1) {
                config_1 = config_1_1;
            }
        ],
        execute: function () {/// <reference path="../../headers/common.d.ts" />
            PanelCtrl = /** @class */ (function (_super) {
                __extends(PanelCtrl, _super);
                function PanelCtrl($scope, $injector, templateSrv, $sce, $http) {
                    var _this = _super.call(this, $scope, $injector) || this;
                    _this.base_url = '/qan/settings?var-host=';
                    $scope.trustSrc = function (src) { return $sce.trustAsResourceUrl(src); };
                    $scope.qanParams = {
                        'theme': config_1.default.bootData.user.lightTheme ? 'light' : 'dark'
                    };
                    var setUrl = function () {
                        // translates Grafana's variables into iframe's URL;
                        $scope.url = _this.base_url + templateSrv.variables[0].current.value;
                        $scope.url += '&theme=' + $scope.qanParams.theme;
                    };
                    $scope.$root.onAppEvent('template-variable-value-updated', setUrl);
                    setUrl();
                    return _this;
                }
                PanelCtrl.prototype.link = function ($scope, elem) {
                    var frame = elem.find('iframe');
                    var panel = elem.find('div.panel-container');
                    var panelContent = elem.find('div.panel-content');
                    panel.css({
                        'background-color': 'transparent',
                        'border': 'none'
                    });
                    this.disableGrafanaPerfectScroll(elem);
                    this.fixMenuVisibility(elem);
                    $scope.ctrl.calculatePanelHeight = function () {
                        var h = frame.contents().find('body').height() || 400;
                        var documentH = (elem && elem[0]) ? elem[0].ownerDocument.height : h;
                        $scope.ctrl.containerHeight = documentH;
                        $scope.ctrl.height = documentH - 100;
                        frame.height(h + 100 + "px");
                        panel.height(h + 150 + "px");
                        panelContent.height("inherit");
                    };
                    frame.on('load', function () {
                        $scope.ctrl.calculatePanelHeight();
                        frame.contents().bind('click', function () { return setTimeout(function () { return $scope.ctrl.calculatePanelHeight(); }, 10); });
                        frame.contents().bind('DOMSubtreeModified', function () { return setTimeout(function () { return $scope.ctrl.calculatePanelHeight(); }, 10); });
                    });
                };
                /**
                 * Workaround for scrolling through iframe
                 * Grafana perfect scroll is broken for iframe and should be disabled for this case
                 * @param elem - qan app panel HTML element
                 * @returns {void, boolean}
                 */
                PanelCtrl.prototype.disableGrafanaPerfectScroll = function (elem) {
                    if (!elem || !elem[0])
                        return false;
                    var perfectScrollContainers = elem[0].ownerDocument.getElementsByClassName('ps');
                    var rightScrollbarContainers = elem[0].ownerDocument.getElementsByClassName('ps__thumb-y');
                    [].forEach.call(perfectScrollContainers, function (container) { return container.setAttribute('style', 'overflow: auto !important'); });
                    [].forEach.call(rightScrollbarContainers, function (container) { return container.setAttribute('style', 'display: none !important'); });
                };
                PanelCtrl.prototype.fixMenuVisibility = function (elem) {
                    if (!elem || !elem[0])
                        return false;
                    var menu = elem[0].ownerDocument.getElementsByClassName('dropdown-menu');
                    [].forEach.call(menu, function (e) { return e.setAttribute('style', 'z-index: 1001'); });
                };
                PanelCtrl.template = "\n\t\t<iframe ng-src=\"{{ trustSrc(url) }}\"\n\t\t\tstyle=\"width: 100%; height: 400px; border: 0;\" scrolling=\"no\" />\n\t";
                return PanelCtrl;
            }(sdk_1.MetricsPanelCtrl));
            exports_1("PanelCtrl", PanelCtrl);
        }
    };
});
//# sourceMappingURL=module.js.map